/**
 * Automatically bound by the ScriptBind framework.
 * Dont forget to press F7 to check its validity.
 *
 *
 */
(function () {

	
	/**
	 * This map has state, we give it save and load functions.
	 */
	return {
		save: function () { },
		load: function (state) {},
		
		/**
		 * Map scripts.
		 * Empty ones can be omitted if desired.
		 */
		mapEnter: function () {

			// WARP variable used by teleporthica.js to define multiple entrypoints
			WARP = {
				mapname:"Inside the houses",
				// entrypoints defined in warps from kamajs_village_return.rmp triggers. 
			};

			if( GetMapFlag('HasAccessOutsideOfKamajsReturn', 'kamajs/kamajs_village_return.rmp') ){
				//TODO: restore entrance to elderhouse
				DestroyPerson('elder_storagehouse');
			}

		},

		// The elder while in the storage house:
		elder_storagehouse:{
			create: function(){
				SetPersonDirection(GetCurrentPerson(), "looksouth");
				// Give this poor man some clothes
				Game.mixrss.SetSpritebase( GetPersonSpriteset(GetCurrentPerson()) );
				Game.mixrss.overMix("male/body/02.labcoat_white.rss");
				Game.mixrss.overMix("male/legs/01.shoes_redsneakers.rss", ColorMatrix["Swap_red_and_blue"]);
				SetPersonSpriteset(GetCurrentPerson(), Game.mixrss.GetSpritebase());
			},
			talk: function(){
				Game.lithonite.facePerson(undefined, GetCurrentPerson(), 'look', 'look', true);
				var say = "hmmm";
				if(	 GetMapFlag('Kamajs_negociations', 'kamajs/kamajs_village_return.rmp') && 
					!GetMapFlag('HasAccessOutsideOfKamajsReturn', 'kamajs/kamajs_village_return.rmp')
				){
					nQ(SetMapFlag, null, 'HasAccessOutsideOfKamajsReturn', 1, 'kamajs/kamajs_village_return.rmp');
					say = "Ah, you're that foreigner that has been roaming our campsite."
					+ " Listen, we're very busy at the moment storing our supplies. If you want board and room, then"
					+ " do this for me: There was this girl who left without paying, our sensors picked up her lifesigns in the mines."
					+ " Near the entrance of the mines you'll find a pickaxe, make sure you take it with you, sometimes there is vermin lurking around"
					+ " Bring her back and you can sleep in our inn, 'kay?";
				}
				else if( GetMapFlag('Kamajs_negociations', 'kamajs/kamajs_village_return.rmp') )
					say =  "Listen, we're really busy. The girl in the mine, go south then east, there should be a cavern entry."
					+ " Ok?";
				else
					say = "I am the Village Elder, I should be in my house.";


				nQ({ action: 'Talk',
					caption: "Villager",
					settings:{ nameWindowAlignment : ALIGNMENT_TOPRIGHT }, // captionWindowAlignment
					text:  say
				});
				nQ(Game.lithonite.unfacePerson, Game.lithonite, undefined, GetCurrentPerson());
				CutScene_Play('TalkTo elder_storagehouse');
			}
		}

	};
})();
